Attribute VB_Name = "Keyboard"
' RealTimer project

' File:           Keyboard.bas
' Author:      Colupaika at OpenScience Ltd
' Modif date: 08 - 2008
' Version:  2.0
' Distributed under GNU GPL v 2

'This module includes keyboard procedures (key input)
'and also key file storage procedures

Declare Function GetAsyncKeyState Lib "USER32" (ByVal vKey As Long) As Integer
Declare Function GetKeyState Lib "USER32" (ByVal nVirtKey As Long) As Integer
Declare Function GetKeyboardState Lib "USER32" (pbKeyState As Byte) As Boolean
Declare Function GetKeyNameText Lib "USER32" Alias "GetKeyNameTextA" (ByVal lParam As Long, ByVal lpBuffer As String, ByVal nSize As Long) As Long

Declare Sub keybd_event Lib "USER32" (ByVal bVk As Byte, ByVal bScan As Byte, ByVal dwFlags As Long, ByVal dwExtraInfo As Long)
Public Const VK_SCROLL = &H91

'Type ButtonName
'    Name As String * 10
'End Type
Public Btn(1 To 256) As String
Public KeyFileName As String
Public KeyFileTitle As String
Const AddKey_ind1 = 48
Const AddKey_ind2 = 95
Public NumAdditionalKeys As Integer

Sub WaitForEsc()
Dim ret As Long
    Do
        DoEvents
        ret = GetKeyState(27)
    Loop Until Not ret And 32768
End Sub

Sub ScrollLock()
'imitate scroll lock pressing - getting light on and off
keybd_event VK_SCROLL, 0, 0, 0 'button down
keybd_event VK_SCROLL, 0, 2, 0 'button up
End Sub

Sub MakeAdditionalKeys()
Dim i As Integer
Dim k As Integer
Dim numAddKeys As Integer
Dim KeyCode(AddKey_ind1 To AddKey_ind2) As Boolean
numAddKeys = AddKey_ind2 - AddKey_ind1 + 1

'     
For i = 1 To NumKeys
    If key(i).code >= AddKey_ind1 And key(i).code <= AddKey_ind2 Then
        If KeyCode(key(i).code) = False Then
            KeyCode(key(i).code) = True
            numAddKeys = numAddKeys - 1
        End If
    End If
Next i

'    
ReDim Preserve key(1 To NumKeys + numAddKeys) As KeyType
k = NumKeys
For i = AddKey_ind1 To AddKey_ind2
    If KeyCode(i) = False Then
        k = k + 1
        key(k).code = i
        key(k).comment = Btn(i)
        key(k).Duration = 1
        key(k).Name = key(k).comment
    End If
Next i

' 
For i = 1 To NumKeys
    If key(i).code = 32 Then Exit For
Next i
If i > NumKeys Then
        k = k + 1
        ReDim Preserve key(1 To NumKeys + numAddKeys + 1) As KeyType
        key(k).code = 32
        key(k).comment = Btn(32)
        key(k).Duration = 1
        key(k).Name = key(k).comment
End If

NumAdditionalKeys = k


End Sub

Sub SetButtonNames()

'Public Const VK_BACK = &H8
'Public Const VK_TAB = &H9

'Public Const VK_CLEAR = &HC
'Public Const VK_RETURN = &HD

'Public Const VK_SHIFT = &H10
'Public Const VK_CONTROL = &H11
'Public Const VK_MENU = &H12
'Public Const VK_PAUSE = &H13
'Public Const VK_CAPITAL = &H14

'Public Const VK_ESCAPE = &H1B

'btn(&H8) = "Back"
'btn(&H9) = "Tab"
Btn(&HC) = "Clear"
Btn(&HD) = "Return"

Btn(&H10) = "Shift"
Btn(&H11) = "Control"
Btn(&H12) = "Alt"
Btn(&H13) = "Pause"

Btn(32) = "Space"

Btn(&H21) = "PgUp"
Btn(&H22) = "PgDn"
Btn(&H23) = "End"
Btn(&H24) = "Home"
Btn(&H25) = "Left"
Btn(&H26) = "Up"
Btn(&H27) = "Right"
Btn(&H28) = "Down"
Btn(&H29) = "Select"
Btn(&H2A) = "Print"
Btn(&H2B) = "Execute"
Btn(&H2C) = "Snapshot"
Btn(&H2D) = "Ins"
Btn(&H2E) = "Del"
Btn(&H2F) = "Help"

'&H30-&H7F

For i = 48 To 95 '127
    Btn(i) = Chr(i)
Next i

'Debug.Print &H64

'NumPad
Btn(&H60) = "Num0"
Btn(&H61) = "Num1"
Btn(&H62) = "Num2"
Btn(&H63) = "Num3"
Btn(&H64) = "Num4"
Btn(&H65) = "Num5"
Btn(&H66) = "Num6"
Btn(&H67) = "Num7"
Btn(&H68) = "Num8"
Btn(&H69) = "Num9"

Btn(&H6A) = "*"
Btn(&H6B) = "+"
Btn(&H6C) = "sep"
Btn(&H6D) = "-"
Btn(&H6E) = "."
Btn(&H6F) = "/"

'Public Const VK_MULTIPLY = &H6A
'Public Const VK_ADD = &H6B
'Public Const VK_SEPARATOR = &H6C
'Public Const VK_SUBTRACT = &H6D
'Public Const VK_DECIMAL = &H6E
'Public Const VK_DIVIDE = &H6F

Btn(&H70) = "F1"
'btn(&H71) = "F2" '  
Btn(&H72) = "F3"
'btn(&H73) = "F4"
Btn(&H74) = "F5"
'btn(&H75) = "F6"
Btn(&H76) = "F7"
Btn(&H77) = "F8"
Btn(&H78) = "F9"
Btn(&H79) = "F10"
Btn(&H7A) = "F11"
Btn(&H7B) = "F12"
Btn(&H7C) = "F13"
Btn(&H7D) = "F14"
Btn(&H7E) = "F15"
Btn(&H7F) = "F16"
Btn(&H80) = "F17"
Btn(&H81) = "F18"
Btn(&H82) = "F19"
Btn(&H83) = "F20"
Btn(&H84) = "F21"
Btn(&H85) = "F22"
Btn(&H86) = "F23"
Btn(&H87) = "F24"

'Public Const VK_F1 = &H70
'Public Const VK_F2 = &H71
'Public Const VK_F3 = &H72
'Public Const VK_F4 = &H73
'Public Const VK_F5 = &H74
'Public Const VK_F6 = &H75
'Public Const VK_F7 = &H76
'Public Const VK_F8 = &H77
'Public Const VK_F9 = &H78
'Public Const VK_F10 = &H79
'Public Const VK_F11 = &H7A
'Public Const VK_F12 = &H7B
'Public Const VK_F13 = &H7C
'Public Const VK_F14 = &H7D
'Public Const VK_F15 = &H7E
'Public Const VK_F16 = &H7F
'Public Const VK_F17 = &H80
'Public Const VK_F18 = &H81
'Public Const VK_F19 = &H82
'Public Const VK_F20 = &H83
'Public Const VK_F21 = &H84
'Public Const VK_F22 = &H85
'Public Const VK_F23 = &H86
'Public Const VK_F24 = &H87
'
'Public Const VK_NUMLOCK = &H90
'Public Const VK_SCROLL = &H91
'

Btn(&HA0) = "LShift"
Btn(&HA1) = "RShift"
Btn(&HA2) = "LCtrl"
Btn(&HA3) = "RCtrl"
Btn(&HA4) = "LMenu"
Btn(&HA5) = "RMenu"


Btn(186) = ";"
Btn(187) = "="
Btn(188) = "<"
Btn(189) = "-"
Btn(190) = ">"
Btn(191) = "/"
Btn(192) = "`"

Btn(219) = "["
Btn(220) = "\"
Btn(221) = "]"
Btn(222) = "'"
Btn(226) = "\"


'new keys from microsoft kb
Btn(&HB5) = "Next Track"
Btn(&HB6) = "Prev Track"
Btn(&HB7) = "Stop"
Btn(&HCD) = "Play/Pause"
Btn(&HE0) = "Volume"
Btn(&HE2) = "Mute"
Btn(&HE3) = "Bass"
Btn(&HE4) = "Treble"
Btn(&HE5) = "Bass Boost"
Btn(&HE9) = "Vol+"
Btn(&HEA) = "Vol-"


'Public Const VK_ATTN = &HF6
'Public Const VK_CRSEL = &HF7
'Public Const VK_EXSEL = &HF8
'Public Const VK_EREOF = &HF9
'Public Const VK_PLAY = &HFA
'Public Const VK_ZOOM = &HFB
'Public Const VK_NONAME = &HFC
'Public Const VK_PA1 = &HFD
'Public Const VK_OEM_CLEAR = &HFE


End Sub

'Function ButtonName(code As Integer) As String
'    ButtonName = NulTrim(RTrim(btn(code).Name))
'End Function

Sub SaveKeyFile()
Dim i As Integer
KeyFileName = CorrectPath(KeyPath) + RTrim(KeyFileTitle) + ".key"

If KeyFileTitle = "" Then
        FStr.hWndOwner = Keys.hWnd
        FStr.hInstance = App.hInstance
        FStr.lpstrFilter = "RealTimer key file (*.key)" + Chr$(0) + "*.key" + Chr$(0) + "  (*.*)" + Chr$(0) + "*.*" + Chr$(0) + Chr$(0)
        FStr.nFilterIndex = 1
        FStr.lpstrFileTitle = String(257, 0)
        FStr.nMaxFileTitle = Len(FStr.lpstrFileTitle) - 1
        FStr.lpstrInitialDir = KeyPath
        FStr.lpstrTitle = "  "
        FStr.flags = OFN_NOCHANGEDIR Or OFN_HIDEREADONLY Or OFN_EXPLORER
        FStr.FileName = KeyFileTitle + String(257 - Len(buf), 0)
        FStr.nMaxFile = Len(FStr.FileName) - 1
        FStr.lStructSize = Len(FStr)
        res = GetSaveFileName(FStr)
        If res = 0 Then Exit Sub
        KeyFileName = NulTrim(FStr.FileName)
        
        KeyFileTitle = XFileName(XName(KeyFileName))
        
        If InStr(LCase(KeyFileName), ".key") = 0 Then KeyFileName = RTrim(KeyFileName) + ".key"
        LastKeyPreset = XFileName(XName(KeyFileName))
End If
        
        WritePrivateProfileString "Common", "Title", KeyFileTitle, KeyFileName
        For i = 1 To NumKeys
            SaveKeyInfo KeyFileName, i
        Next i
        SaveEmptyKeyInfo KeyFileName, NumKeys + 1
        ShortMessage GetRString("Saved", ""), ""
End Sub

Sub LoadKeyFile_ByName(FileName As String)
        Dim i As Integer
        KeyFileName = FileName
        KeyFileTitle = XName(XFileName(KeyFileName)) 'GetKeyFile_Title(filename)
        For i = 1 To 99
            If LoadKeyInfo(FileName, i) = 0 Then Exit For
        Next i
        LastKeyPreset = XFileName(XName(KeyFileName))
        MakeAdditionalKeys
End Sub

Function GetKeyFile_Title(FileName As String) As String
        Dim ret As String
        ret = String(255, 0)
        GetPrivateProfileString "Common", "title", "", ret, 255, FileName
        GetKeyFile_Title = NulTrim(ret)
End Function

Sub LoadKeyFile()
        FStr.hWndOwner = Keys.hWnd
        FStr.hInstance = App.hInstance
        FStr.lpstrFilter = "RealTimer key file (*.key)" + Chr$(0) + "*.key" + Chr$(0) + "  (*.*)" + Chr$(0) + "*.*" + Chr$(0) + Chr$(0)
        FStr.nFilterIndex = 1
        FStr.lpstrFileTitle = String(257, 0)
        FStr.nMaxFileTitle = Len(FStr.lpstrFileTitle) - 1
        FStr.FileName = String(257, 0)
        FStr.nMaxFile = Len(FStr.FileName) - 1
        FStr.lpstrInitialDir = KeyPath
        FStr.lpstrTitle = "  "
        FStr.flags = OFN_FILEMUSTEXIST Or OFN_NOCHANGEDIR Or OFN_HIDEREADONLY Or OFN_EXPLORER
        FStr.lStructSize = Len(FStr)
        res = GetOpenFileName(FStr)
        If res = 0 Then Exit Sub
        LoadKeyFile_ByName NulTrim(FStr.FileName)
End Sub

Sub LoadKeys_OldFormat(FileName As String)
Dim fx As Integer
Dim buf As String
fx = FreeFile
Open FileName For Input As #fx
NumKeys = 0
While Not EOF(fx)
    Line Input #1, buf
    ASCII2ANSI buf
    NumKeys = NumKeys + 1
    If NumKeys > UBound(key) Then ReDim Preserve key(1 To NumKeys) As KeyType
    If Left$(buf, 1) = " " Then key(NumKeys).code = Asc(Mid(buf, 2, 1)) Else key(NumKeys).code = Asc(Left(buf, 1))
    key(NumKeys).comment = RTrim(Mid(buf, 23, 30))
    key(NumKeys).Name = RTrim(Mid(buf, 53, 8))
Wend
Close #fx
KeyFileName = FileName
KeyFileTitle = "Old RTIME keys"
End Sub
