Attribute VB_Name = "PlanTimer_Main"
' RealTimer project

' File:           PlanTimer_main.bas
' Author:      Colupaika at OpenScience Ltd
' Modif date: 08 - 2008
' Version:  2.0
' Developed under VB 5.0

' Distributed under GNU GPL v 2

'This file includes the most of procedures for PlanTimer including graphical output to the PlanTimer form

'This product includes software developed by vbAccelerator (http://vbaccelerator.com/)
'(see cCustomClipboard and cScrollBars classes)


Declare Function WritePrivateProfileString Lib "kernel32.DLL" Alias "WritePrivateProfileStringA" (ByVal AppName$, ByVal keyname$, ByVal keydefault$, ByVal FileName$) As Long
Declare Function GetPrivateProfileString Lib "kernel32.DLL" Alias "GetPrivateProfileStringA" (ByVal AppName$, ByVal keyname$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Long, ByVal FileName$) As Long

Type TmrType
    StartTime As Single
    active As Byte
    TimeLeft As Single
    row As Long  '   
    col As Long
    EndTime As Single
    TimePassed As Single
    TimeFinish As String * 20

End Type

Type PlanTimerInfo
    Name As String * 40
    maxrows As Long
    maxcols As Long
    x0 As Integer '    
    y0 As Integer
    x(1 To 6) As Integer
    xsize As Integer '  
    ysize As Integer
    basic_xsize As Integer
    basic_ysize As Integer
    basic_fontsize As Integer
    NumRows As Long
    currow As Long  '  
    curcol As Long
    urgenttimer As Long  '  
    nextrowurgenttimer As Long  '     " "
    urgentcolor As Long
    ProfileFileName  As String
    BackColor As Long
    On As Boolean '/ 
    'NEW     
    ScrTimerTop As Long
    ScrTimerLeft As Long
    'NEW        
    ScrNumRows As Long
    ScrNumCols As Long
    '  
    ScrXsize As Long
    ScrYsize As Long
    FontSize As Integer
    ScaleOption As Byte
    
    Interval As Single '  
    Dependent As Integer '/   
    TimerDir As Integer '  (-)
    AutoNextTimer As Integer '-    
    NextAnimalTimer As Integer '    -   
    Sound As Byte
    SoundFileName As String
End Type

Type RowType
    Name As String
End Type

Type ColType
    Name As String
    Time As String
End Type

'OLD
Type TimerType
    StartTime As Single
    EndTime As Single
    TimeLeft As Single
    TimePassed As Single
    TimeFinish As String * 20
    active As Byte
    Step As Integer
    AnimalName As String * 20
End Type

Type SelectionType
    Top As Long
    Left As Long
    Visible As Boolean
    busy As Boolean
End Type

Const Default_TimerName = ""
Const Default_TimerTime = "0"
Const Default_TimerTimeText = "::"


Public Sel As SelectionType
Public SelVisible As Boolean

Declare Function TextOut Lib "gdi32" Alias "TextOutA" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal lpString As String, ByVal nCount As Long) As Long
Declare Function Rectangle Lib "gdi32" (ByVal hdc As Long, ByVal x1 As Long, ByVal y1 As Long, ByVal x2 As Long, ByVal y2 As Long) As Long
Declare Function LineTo Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long) As Long
Declare Function MoveToEx Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, lpPoint As POINTAPI) As Long
Declare Function GetTextExtentPoint Lib "gdi32" Alias "GetTextExtentPointA" (ByVal hdc As Long, ByVal lpszString As String, ByVal cbString As Long, lpSize As size) As Long

Type POINTAPI
        x As Long
        y As Long
End Type
Type size
        cx As Long
        cy As Long
End Type

Public pnt As POINTAPI
'Public TimerSet As TimerSetType

',   PlanTimer     
Public TopMost As Boolean

'Public NextRowTimer() As TimerType
'Public NumNextRowTimers As Long

Public maxrows As Long
Public MaxTimer As Long '   ( )   
Public Const PlanTimer_maxcol = 4

'NEW
Public Tmr() As TmrType
Public NumTimers As Long

Dim tRow() As RowType
Dim tCol() As ColType

Public NumberText() As String
Public TimerTimeText() As String
Public TimerName() As String
Public TimerTime() As Single

Dim TimerCount As Integer
Dim TimerCount2 As Integer

Public Ptmr As PlanTimerInfo
Public OldTmr() As TimerType
Private cClip As New cCustomClipboard

Public Plan_CurRow As Integer '  
Public Plan_CurCol As Integer

'selection coords
Public Selleft As Long
Public SelTop As Long

Public planbkcolor As Long

Public PlantimerWindowLeft As Single
Public PlantimerWindowTop As Single
Public PlantimerWindowHeight As Single
Public PlantimerWindowWidth As Single

Public PlantimerWindowState As Integer
Public PlanTimerNoHelp As Byte
Public PlanTimerVisible As Boolean

Dim TimerTableLeft() As Single  '    
Dim TimerTablePassed() As Single  '    
Public clr(1 To 15) As Long

'    topmost-
Public TopMostVisible As Boolean


Sub AddRowsCols(rows As Long, cols As Long)
'     
Dim i As Long

ReDim Preserve NumberText(1 To Ptmr.maxrows + rows + 3) As String
ReDim Preserve TimerName(1 To Ptmr.maxcols + cols + 3) As String
ReDim Preserve TimerTime(1 To Ptmr.maxcols + cols + 3) As Single
ReDim Preserve TimerTimeText(1 To Ptmr.maxcols + cols + 3) As String

For i = Ptmr.maxrows + 1 To Ptmr.maxrows + rows + 3
    NumberText(i) = LTrim(Str(i))
Next i

For i = Ptmr.maxcols + 1 To Ptmr.maxcols + cols + 3
    'TimerTime(i) = 10
    TimerName(i) = ""
    TimerTimeText(i) = ""
Next i

Ptmr.maxcols = Ptmr.maxcols + cols
Ptmr.maxrows = Ptmr.maxrows + rows
End Sub

Sub AddNewTimer(row As Long, col As Long)
Dim i As Long
Dim nextrow As Long

'    -      
        If Ptmr.Dependent = 1 Then
            For i = 1 To NumTimers
                With Tmr(i)
                    If .row = row Then
                        '
                        If .active < 6 And .active > 0 Then
                            .active = 4
                            RefreshInactiveTimer PlanTimer.PlanPic, i
                        End If
                        'Debug.Print .active
                        If .active = 6 Or .active = 10 Or .active = 11 Then
                            '   next row timer
                            DeleteTimer i
                            '.active = 0
                            '.row = 0
                            '.col = 0
                        End If
                    End If
                End With
            Next i
        End If
        
        NumTimers = NumTimers + 1
        ReDim Preserve Tmr(1 To NumTimers) As TmrType
        ReDim Preserve TimerTableLeft(1 To NumTimers)
        ReDim Preserve TimerTablePassed(1 To NumTimers)

        With Tmr(NumTimers)
            .row = row
            .col = col
            .StartTime = Timer
            'temp
           'TimerTime(Ptmr.curcol) = 15
           .TimeFinish = GetTimeFinish(ConvertInt(Time) + TimerTime(col))
           .EndTime = .StartTime + TimerTime(col)
           .active = 1
        End With
        
        If Ptmr.NextAnimalTimer = 1 And col = 1 Then
            'activate next row timer
            nextrow = row + 1
            'test whether next row is busy
                For i = 1 To NumTimers
                    If nextrow = Tmr(i).row And Tmr(i).col And Tmr(i).active < 4 Then Exit For
                Next i
            If i > NumTimers Then
                'timer is free, adding new
                NumTimers = NumTimers + 1
                ReDim Preserve Tmr(1 To NumTimers) As TmrType
                ReDim Preserve TimerTableLeft(1 To NumTimers)
                ReDim Preserve TimerTablePassed(1 To NumTimers)

                With Tmr(NumTimers)
                    .row = nextrow
                    .col = col
                    .StartTime = Timer
                    .TimeFinish = GetTimeFinish(ConvertInt(Time) + Ptmr.Interval)
                    .EndTime = .StartTime + Ptmr.Interval
                    .active = 10
                End With
            End If
        End If
End Sub

Public Sub RepaintAll()
    Dim i As Integer
    RefreshGrid
    RefreshInactiveTimers
    RefreshTimers
    ShowSelection
    For i = 1 To 3
        PlanTimer.PositionTextInput i
    Next i
    'PlanTimer.PlanPic.SetFocus
End Sub

Sub MoveScreenTable()
'Dim i As Integer
    'For i = 1 To Ptmr.ScrNumRows
    '    PlanTimer.NumberText(i - 1).text = tRow(i + Ptmr.ScrTimerTop).Name
    'Next i
End Sub

Sub RefreshTimers()
Dim i As Long
TimerCount = TimerCount + 1

Timers_Estimate
'Refresh planpic

If Ptmr.urgenttimer = 0 Then RefreshUrgent PlanTimer.Urgent, 0, 0

'all timers

For i = 1 To NumTimers
    RefreshOneTimer i, PlanTimer.PlanPic, 0, 0
Next i

'For i = 1 To Ptmr.NumRows
'    RefreshOneTimer i, PlanTimer.PlanPic, 0, 0
'    If OldTmr(i).active = 1 And OldTmr(i).TimeLeft <= 0 Then
'        If TimerCount = 3 Then ShowActualIcon i
'        If TimerCount = 6 Then HideActualIcon i
'    End If
'    If OldTmr(i).active = 4 Then OldTmr(i).active = 0
'Next i

'nextrow timers
'For i = 1 To NumNextRowTimers
'    RefreshNextRowTimer i, PlanTimer.PlanPic, 0, 0
'Next i

If TimerCount >= 6 Then TimerCount = 0
PlanTimer.PlanPic.refresh
DoEvents
End Sub

Sub ShowActualIcon(ctrl As Control, x As Integer, y As Integer)
                Dim h As Integer
                Dim w As Integer
                Dim y2 As Integer
                Dim x2 As Integer
                h = PlanTimer.ActualCellImage(Ptmr.ScaleOption).Height
                w = PlanTimer.ActualCellImage(Ptmr.ScaleOption).Width
                y2 = y + 3
                x2 = x + 3
                
                
               ctrl.FillColor = ctrl.BackColor
              'ctrl.ForeColor = ctrl.FillColor
                ctrl.FillStyle = 0
                ctrl.DrawStyle = 5
                Rectangle ctrl.hdc, x2, y2, x2 + Ptmr.xsize - 4, y2 + h
                BitBlt ctrl.hdc, x2, y2, w, h, PlanTimer.ActualCellImage(Ptmr.ScaleOption).hdc, 0, 0, vbSrcAnd
                BitBlt ctrl.hdc, x2, y2, w, h, PlanTimer.ActualCellImage(Ptmr.ScaleOption).hdc, 0, 0, vbMergePaint
End Sub

Sub HideActualIcon(ctrl As Control, x As Integer, y As Integer)
'   Dim x As Integer
'   Dim y As Integer
Dim h As Integer
Dim y2 As Integer
Dim x2 As Integer
   
            h = PlanTimer.ActualCellImage(Ptmr.ScaleOption).Height
            y2 = y + 3
            x2 = x + 3
'            x = Ptmr.x0 + Ptmr.xsize * (Tmr(i).col) + 3
'            y = Ptmr.y0 + Ptmr.ysize * (Tmr(i).row - 1) + (Ptmr.ysize - h) / 2 + 1
            ctrl.FillColor = ctrl.BackColor
            'ctrl.ForeColor = .PlanPic.BackColor
            ctrl.FillStyle = 0
            ctrl.DrawStyle = 5
            Rectangle ctrl.hdc, x2, y2, x2 + PlanTimer.ActualCellImage(Ptmr.ScaleOption).Width, y2 + h
            '.PlanPic.DrawStyle = 0
End Sub

Sub RefreshGrid()
Dim i As Integer
Dim y As Integer
Dim x As Integer
Dim stp As Integer
Dim buf As String

With PlanTimer.PlanPic

.FontSize = Ptmr.FontSize
.Cls

.DrawWidth = 1
.DrawStyle = 0
.DrawMode = 13
.FillStyle = vbSolid
.FillColor = PlanTimer.BackColor
.ForeColor = PlanTimer.BackColor
Rectangle .hdc, 0, 0, Ptmr.x0, .ScaleHeight
Rectangle .hdc, 0, 0, .ScaleWidth, Ptmr.y0 - 1

.DrawWidth = 1
.DrawStyle = 0
.DrawMode = 13
.ForeColor = PlanTimer.BackColor

For i = 1 To Ptmr.ScrNumRows + 1
    y = Ptmr.y0 + i * Ptmr.ysize - 1
    MoveToEx .hdc, Ptmr.x0 + 1, y, pnt
    LineTo .hdc, .ScaleWidth, y
Next i

.ForeColor = SkinColor(2)

For i = 1 To Ptmr.ScrNumRows + 3
    y = Ptmr.y0 + i * Ptmr.ysize - 1
    MoveToEx .hdc, 0, y, pnt
    LineTo .hdc, Ptmr.x0, y
    
    y = Ptmr.y0 + (i - 0.8) * Ptmr.ysize
    x = i + Ptmr.ScrTimerTop
    If x - 3 > Ptmr.maxrows Then Exit For
    buf = NumberText(x)
    TextOut .hdc, Ptmr.x0 - TextLen(.hdc, buf) - 4, y, buf, Len(buf)
Next i

.ForeColor = PlanTimer.BackColor
For i = 1 To Ptmr.ScrNumCols + 1
    x = Ptmr.x0 + i * Ptmr.xsize
    MoveToEx .hdc, x, Ptmr.y0, pnt
    LineTo .hdc, x, .ScaleHeight
Next i

.ForeColor = SkinColor(2)
Rectangle .hdc, -1, -1, Ptmr.x0 + 1, Ptmr.y0
For i = 1 To Ptmr.ScrNumCols + 3
    x = Ptmr.x0 + i * Ptmr.xsize
    MoveToEx .hdc, x, 0, pnt
    LineTo .hdc, x, Ptmr.y0 - 1
    
    y = i + Ptmr.ScrTimerLeft
    If y - 3 > Ptmr.maxcols Then Exit For
    
    If TimerName(y) = "" Then buf = Default_TimerName + Str(y) Else buf = TimerName(y)
    TextOut .hdc, x - (Ptmr.xsize + TextLen(.hdc, buf)) \ 2, Ptmr.y0 - Ptmr.ysize * 2 + 4, buf, Len(buf)
    
    If TimerTimeText(y) = "" Then buf = Default_TimerTimeText Else buf = TimerTimeText(y)
    TextOut .hdc, x - (Ptmr.xsize + TextLen(.hdc, buf)) \ 2, Ptmr.y0 - Ptmr.ysize + 4, buf, Len(buf)
Next i
End With
Selleft = 0
SelTop = 0
End Sub

Sub ShowSelection()
Dim x1 As Long
Dim x2 As Long
Dim y1 As Long
Dim y2 As Long
Dim newrow As Long
Dim newcol As Long

newrow = Ptmr.currow - Ptmr.ScrTimerTop
newcol = Ptmr.curcol - Ptmr.ScrTimerLeft

With PlanTimer.PlanPic
    'Erase old selection
    x1 = Selleft
    y1 = SelTop
    x2 = x1 + Ptmr.xsize - 2
    y2 = y1 + Ptmr.ysize - 2
    
If Selleft > 0 And SelTop > 0 And (x2 > Ptmr.x0 And x1 < Ptmr.ScrXsize) And (y2 > Ptmr.y0 And y1 < Ptmr.ScrYsize) Then
    .FillColor = 0 ' planbkcolor
    .FillStyle = 1
    .DrawStyle = 0
    .DrawMode = 13
    .DrawWidth = 3
    .DrawStyle = 0
    .DrawWidth = 2
    .ForeColor = planbkcolor
    Rectangle .hdc, x1, y1, x2, y2
End If

If SelVisible = False Then Exit Sub

'Draw new selection
x1 = Ptmr.x0 + CLng(Ptmr.xsize * (newcol - 1)) + 2
y1 = Ptmr.y0 + CLng(Ptmr.ysize * (newrow - 1)) + 1
x2 = x1 + Ptmr.xsize - 2
y2 = y1 + Ptmr.ysize - 2

If (x2 > Ptmr.x0 And x1 < Ptmr.ScrXsize) And (y2 > Ptmr.y0 And y1 < Ptmr.ScrYsize) Then
    .FillColor = 0 ' planbkcolor
    .FillStyle = 1
    .DrawStyle = 0
    .DrawMode = 13
    .DrawWidth = 3
    .DrawWidth = 2
    .ForeColor = PlanTimer.CurrentTime.ForeColor
    Rectangle .hdc, x1, y1, x2, y2
End If
.refresh
End With
Selleft = x1
SelTop = y1
End Sub

Sub SaveProfile()
    If PlanTimer.FileNameText.text <> "" Then
        CheckPath TimerPath
        Ptmr.ProfileFileName = CorrectPath(TimerPath) + RTrim(PlanTimer.FileNameText.text) + ".tmr"
        SaveTimerSet Ptmr.ProfileFileName
        ShortMessage GetRString("Saved", ""), "PlanTimer"
        PlanTimer.frmSaveFile.Enabled = False
        PlanTimer.frmSaveFile.Visible = False
        PlanTimer.PlanPic.SetFocus
    End If
End Sub

Sub LoadProfile()
If CheckPlanTimerData = True Then
    Do
        ret = AskQuestion(GetRString("c_NewProfileNeeds", "       .") + " " + GetRString("c_AreYouSure_DelTimers", "   ?"), 2)
        If ret = 1 Then Exit Do
        If ret = 2 Or ret = -1 Then Exit Sub
    Loop
End If
    
    Ptmr.ProfileFileName = CorrectPath(TimerPath) + RTrim(PlanTimer.FileList.List(PlanTimer.FileList.ListIndex))
    If InStr(LCase(Ptmr.ProfileFileName), ".tmr") = 0 Then Ptmr.ProfileFileName = Ptmr.ProfileFileName + ".tmr"
    ReadTimerSet Ptmr.ProfileFileName
    ClearTimers
    PlanTimer.frmLoadFile.Enabled = False
    PlanTimer.frmLoadFile.Visible = False
    PlanTimer.PlanPic.Cls
    RefreshGrid
    PlanTimer.PlanPic.SetFocus
End Sub


Sub SaveTimerSet(FileName As String)
Dim i As Long
Dim Index As Integer
Dim buf As String
Dim Header As String
Dim ret As String

IniFile = FileName
If InStr(LCase(IniFile), ".tmr") = 0 Then IniFile = IniFile + ".tmr"

With Ptmr
    
    WritePrivateProfileString "TimerSet", "Name", RTrim(.Name), IniFile$
    WritePrivateProfileString "TimerSet", "Interval", PlanTimer.Interval.text, IniFile$
    
    WritePrivateProfileString "TimerSet", "TimerDirection", LTrim(Str(Ptmr.TimerDir)), IniFile$
    WritePrivateProfileString "TimerSet", "Dependent", LTrim(Str(Ptmr.Dependent)), IniFile$
    WritePrivateProfileString "TimerSet", "AutoNextTimer", LTrim(Str(Ptmr.AutoNextTimer)), IniFile$
    WritePrivateProfileString "TimerSet", "NextAnimalTimer", LTrim(Str(Ptmr.NextAnimalTimer)), IniFile$
    WritePrivateProfileString "TimerSet", "Sound", Ptmr.Sound, IniFile$
    WritePrivateProfileString "TimerSet", "SoundFileName", Ptmr.SoundFileName, IniFile$
  
    WritePrivateProfileString "TimerSet", "CurRow", Ptmr.currow, IniFile$
    WritePrivateProfileString "TimerSet", "CurCol", Ptmr.curcol, IniFile$
  
    Index = 0
    For i = 1 To .maxcols
        If TimerName(i) <> "" Or TimerTimeText(i) <> "" Then
            '     
            Index = Index + 1
            Header = "Timer_" + LTrim(Str(Index))
            WritePrivateProfileString Header, "Index", LTrim(Str(i)), IniFile$
            WritePrivateProfileString Header, "Name", RTrim(TimerName(i)), IniFile$
            WritePrivateProfileString Header, "Time", RTrim(TimerTimeText(i)), IniFile$
        End If
    Next i
    Index = 0
    For i = 1 To .maxrows
            ret = String(255, 0)
            GetPrivateProfileString Header, "Index", "", ret, 255, IniFile
            ret = NulTrim(ret)
            If NumberText(i) <> LTrim(Str(i)) Or ret <> "" Then
                '  
                Index = Index + 1
                Header = "Row_" + LTrim(Str(Index))
                WritePrivateProfileString Header, "Index", LTrim(Str(i)), IniFile$
                WritePrivateProfileString Header, "Name", RTrim(NumberText(i)), IniFile$
            End If
    Next i
    End With
ProfileSaved = True
PlanTimer.Caption = XName(XFileName(Ptmr.ProfileFileName)) + "  -  " + "PlanTimer"
End Sub

Sub ReadTimerSet(FileName As String)
'     

Dim i As Long
Dim buf As String
Dim ret As String
Dim Header As String
Dim old_numrows As Integer
Dim old_numcols As Integer
Dim Index As Long
Dim count As Integer

IniFile = FileName
    
    With Ptmr
        
        GetINIparam "TimerSet", "Name", ret$, ""
        .Name = ret
        GetINIparam "TimerSet", "Interval", ret$, "5 "
        PlanTimer.Interval.text = ret
        Ptmr.Interval = ConvertInt(ret)
        
        GetINIparam "TimerSet", "TimerDirection", ret, "1"
        Ptmr.TimerDir = Val(ret)

        GetINIparam "TimerSet", "Dependent", ret$, "1"
        .Dependent = Val(ret)
        
        GetINIparam "TimerSet", "AutoNextTimer", ret, "0"
        Ptmr.AutoNextTimer = Val(ret)
        
        GetINIparam "TimerSet", "NextAnimalTimer", ret, "0"
        Ptmr.NextAnimalTimer = Val(ret)
        
        GetINIparam "TimerSet", "Sound", ret, "0"
        Ptmr.Sound = Val(ret)
        GetINIparam "TimerSet", "SoundFileName", ret, ""
        Ptmr.SoundFileName = ret

        GetINIparam "TimerSet", "CurRow", ret, "1"
        Ptmr.currow = Val(ret)
        GetINIparam "TimerSet", "CurCol", ret, "1"
        Ptmr.curcol = Val(ret)
        If Ptmr.currow < 1 Then Ptmr.currow = 1
        If Ptmr.curcol < 1 Then Ptmr.curcol = 1
        
'     ,  ,   
'   " ",  
        
' 
    ReDim TimerName(1 To Ptmr.maxcols + 3) As String
    ReDim TimerTime(1 To Ptmr.maxcols + 3) As Single
    ReDim TimerTimeText(1 To Ptmr.maxcols + 3) As String
    ReDim NumberText(1 To Ptmr.maxrows + 3) As String
For i = 1 To Ptmr.maxrows + 3
    NumberText(i) = LTrim(Str(i))
Next i
For i = 1 To Ptmr.maxcols + 3
    'TimerTime(i) = 10
    TimerName(i) = ""
    TimerTimeText(i) = ""
Next i
        
        
'  
    ret = String(255, 0)
    
'    GetPrivateProfileString "TimerSet", "Numrows", "", ret$, 255, IniFile
'    ret = NulTrim(ret)
    
    GetPrivateProfileString "Timer_1", "Index", "", ret$, 255, IniFile
    ret = NulTrim(ret)
    
    
    If ret <> "" Then
        '   
        i = 0
        Do
            i = i + 1
            Header = "Timer_" + LTrim(Str(i))
            ret = String(255, 0)
            GetPrivateProfileString Header, "Index", "", ret$, 255, IniFile
            Index = Val(NulTrim(ret))
            If Index > 0 Then
                If Index > .maxcols Then
                    .maxcols = Index + 10
                    ReDim Preserve TimerName(1 To Ptmr.maxcols + 3) As String
                    ReDim Preserve TimerTime(1 To Ptmr.maxcols + 3) As Single
                    ReDim Preserve TimerTimeText(1 To Ptmr.maxcols + 3) As String
                End If
                GetINIparam Header, "Name", ret$, ""
                    TimerName(Index) = ret
                GetINIparam Header, "Time", ret$, ""
                    TimerTimeText(Index) = ret
                    TimerTime(Index) = ConvertInt(ret)
            Else
                Exit Do
            End If
        Loop
        
        i = 0
        Do
            i = i + 1
            Header = "Row_" + LTrim(Str(i))
            ret = String(255, 0)
            GetPrivateProfileString Header, "Index", "", ret$, 255, IniFile
            Index = Val(NulTrim(ret))
            If Index > 0 Then
                count = 0
                If Index > .maxrows Then
                    .maxrows = Index + 10
                    ReDim Preserve NumberText(1 To Ptmr.maxrows + 3) As String
                End If
                GetINIparam Header, "Name", ret$, ""
                    NumberText(Index) = ret
            Else
                count = count + 1
                If count > 32 Then Exit Do
            
            '    Exit Do
            End If
        Loop
    
    Else
    
    ' 
        GetINIparam "TimerSet", "Numrows", ret$, "100"
        old_numrows = Val(ret)
        GetINIparam "TimerSet", "Numcols", ret$, "4"
        old_numcols = Val(ret)
        
        '.maxcols = old_numcols
        
        If Ptmr.maxcols = 0 Then Ptmr.maxcols = 100
        
        ReDim Preserve TimerName(1 To Ptmr.maxcols + 3) As String
        ReDim Preserve TimerTime(1 To Ptmr.maxcols + 3) As Single
        ReDim Preserve TimerTimeText(1 To Ptmr.maxcols + 3) As String
                
        For i = 1 To old_numcols
            buf = LTrim(Str(i))
            If Len(buf) < 2 Then buf = "0" + buf
            GetINIparam "TimerSet", "TimerName_" + buf, ret$, "" + buf
            TimerName(i) = ret
            GetINIparam "TimerSet", "TimerTime_" + buf, ret$, ""
            TimerTimeText(i) = ret
            TimerTime(i) = ConvertInt(ret)
        Next i
        
        If Ptmr.maxrows = 0 Then Ptmr.maxrows = 100
        ReDim Preserve NumberText(1 To Ptmr.maxrows + 3) As String
        For i = 1 To old_numrows
            buf = LTrim(Str(i))
            If Len(buf) < 3 Then buf = "0" + buf
            If Len(buf) < 3 Then buf = "0" + buf
            GetINIparam "TimerSet", "RowName_" + buf, ret$, LTrim(Str(i))
            NumberText(i) = ret
        Next i
    End If
    End With


Ptmr.ProfileFileName = FileName
ProfileSaved = True
PlanTimer.Caption = XFileName(XName(Ptmr.ProfileFileName)) + "  -  " + "PlanTimer"
End Sub

Sub PlanTimer_ReadIni()
Dim ret As String
Dim i As Integer

' :    Ini  apppath,   .
'   ,   app.path (    )

SetIniPath

'If Dir(CorrectPath(IniPath) + Plan_IniFileName) = "" Then
'    IniFile$ = CorrectPath(App.path) + Plan_IniFileName
'Else
    IniFile$ = IniPath$ + Plan_IniFileName
'End If

        GetINIparam "PlanTimer", "PlantimerWindowLeft", ret$, "1000"
        PlantimerWindowLeft = CSng(ret)
        
        GetINIparam "PlanTimer", "PlantimerWindowTop", ret$, "1000"
        PlantimerWindowTop = CSng(ret)
        
        GetINIparam "PlanTimer", "PlantimerWindowState", ret$, "0"
        PlantimerWindowState = CLng(ret)
        
        GetINIparam "PlanTimer", "PlantimerWindowHeight", ret$, "8000"
        PlantimerWindowHeight = CSng(ret)
        
        GetINIparam "PlanTimer", "PlantimerWindowWidth", ret$, "12000"
        PlantimerWindowWidth = CSng(ret)
        
        
        GetINIparam "PlanTimer", "Plantimer_S_WindowLeft", ret$, "0"
        WinLeft = CSng(ret)
        GetINIparam "PlanTimer", "Plantimer_S_WindowTop", ret$, "0"
        WinTop = CSng(ret)
        
        GetINIparam "PlanTimer", "PlantimerNoHelp", ret$, "0"
        PlanTimerNoHelp = Val(ret)

GetINIparam "PlanTimer", "MaxRows", ret, "100"
    maxrows = Val(ret)
    If maxrows <= 0 Then maxrows = 100
    
If Portable = 0 Then
    GetINIparam "PlanTimer", "ProfileFileName ", ret, CorrectPath(TimerPath) + GetRString("c_NoName", " ") + ".tmr"
    Ptmr.ProfileFileName = RTrim(ret)
Else
    Ptmr.ProfileFileName = CorrectPath(App.path) + "Timers\" + GetRString("c_NoName", " ") + ".tmr"
End If

GetINIparam "PlanTimer", "Scale", ret, "1"
    Ptmr.ScaleOption = Val(ret)
    
    
SetMyDocPaths
'IniFile$ = IniPath$ + Plan_IniFileName

'GetINIparam "Common", "KeyPath", ret$, KeyPath
'KeyPath = ret

If Portable = 0 Then
    GetINIparam "PlanTimer", "TimerPath", ret$, TimerPath
    TimerPath = ret
Else
    TimerPath = CorrectPath(App.path) + "Timers"
End If

    
End Sub

Sub PlanTimer_SaveINI()
On Local Error GoTo SaveIniErr

SetIniPath
IniFile = IniPath + Plan_IniFileName
  
WritePrivateProfileString "PlanTimer", "PlanTimerWindowLeft", CStr(PlantimerWindowLeft), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimerWindowTop", CStr(PlantimerWindowTop), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimerWindowHeight", CStr(PlantimerWindowHeight), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimerWindowWidth", CStr(PlantimerWindowWidth), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimerWindowState", CStr(PlantimerWindowState), IniFile$

WritePrivateProfileString "PlanTimer", "PlanTimer_S_WindowTop", CStr(WinTop), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimer_S_WindowLeft", CStr(WinLeft), IniFile$

WritePrivateProfileString "PlanTimer", "PlanTimerNoHelp", CStr(PlanTimerNoHelp), IniFile$
If Portable = 0 Then WritePrivateProfileString "PlanTimer", "TimerPath", TimerPath, IniFile$


'WritePrivateProfileString "PlanTimer", "TimerDirection", LTrim(Str(Ptmr.TimerDir)), IniFile

If Portable = 0 Then WritePrivateProfileString "PlanTimer", "ProfileFileName ", Ptmr.ProfileFileName, IniFile
WritePrivateProfileString "PlanTimer", "Scale", Ptmr.ScaleOption, IniFile$

Exit Sub

SaveIniErr: Resume Next
End Sub



'Get the length of a string for given HDC
Public Function TextLen(thdc As Long, buf As String) As Integer
Dim res As Long
Dim t_size As size
res = GetTextExtentPoint(thdc, buf, Len(buf), t_size)
TextLen = t_size.cx
End Function

Sub CheckPath(path As String)
'    
'  -  
On Local Error GoTo CheckPathErr
If path = "" Then
    path = App.path
    Exit Sub
End If
If Dir(path, vbDirectory) = "" Then
    MkDir path
End If
CheckPathExit:
Exit Sub
CheckPathErr:
path = App.path
Resume CheckPathExit
End Sub

Sub ClearTimers()
Dim i As Integer

NumTimers = 0

        ReDim Tmr(1 To 1) As TmrType
        ReDim TimerTableLeft(1 To 1)
        ReDim TimerTablePassed(1 To 1)
        
Ptmr.urgenttimer = 0
Ptmr.nextrowurgenttimer = 0

Ptmr.currow = 1
Ptmr.curcol = 1
End Sub

Sub RefreshSuspendedTimers(ctrl As Control)
Dim i As Long
'refresh suspended timers
For i = 1 To MaxTimer
    If OldTmr(i).active = 2 Then
        OldTmr(i).active = 1
        RefreshOneTimer i, ctrl, 0, 0
        OldTmr(i).active = 2
    End If
Next i
End Sub

Sub RefreshInactiveTimers()
Dim i As Long
Dim x As Integer
Dim y As Integer
Dim buf As String

For i = 1 To NumTimers
            RefreshInactiveTimer PlanTimer.PlanPic, i
Next i
End Sub

Sub RefreshInactiveTimer(ctrl As Control, i As Long)
   Dim buf As String
   Dim x As Integer
   Dim y As Integer
   
   If GetTimerCoord(i, x, y) = 0 Then Exit Sub
   'inactive
    With Tmr(i)
        If .active = 4 Then
                        
            ctrl.ForeColor = ctrl.BackColor
            ctrl.FillColor = ctrl.BackColor
            ctrl.FillStyle = 0
            ctrl.DrawStyle = 5
            Rectangle ctrl.hdc, x + 3, y + 2, x + Ptmr.xsize - 1, y + Ptmr.ysize - 2
            ctrl.ForeColor = SkinColor(11)
            If Ptmr.TimerDir = 1 Then
                buf = TimeFormat(CLng(.TimeLeft))
                TextOut ctrl.hdc, x + Ptmr.xsize - TextLen(ctrl.hdc, buf) - 4, y + 4, buf, Len(buf)
            Else
                buf = TimeFormat(CLng(.TimePassed))
                TextOut ctrl.hdc, x + 4, y + 4, buf, Len(buf)
            End If
        End If
    End With
End Sub

Function ConvertInt(text As String) As Single
Dim i As Integer
Dim t As Integer
Dim numpnt As Integer
Dim pnt(1 To 3) As Double
Dim result As Single
Dim Value As String
Dim h As Single

If InStr(text, "") > 0 Or InStr(text, "h") > 0 Then
    ConvertInt = Val(text) * 3600
    Exit Function
End If

If InStr(text, "") > 0 Or InStr(text, "m") > 0 Then
    ConvertInt = Val(text) * 60
    Exit Function
End If

If InStr(text, "") > 0 Or InStr(text, "s") > 0 Then
    ConvertInt = Val(text)
    Exit Function
End If

Value = text
'
i = InStr(Value, ".")
If i > 0 Then
    result = Val(Mid(Value, i + 1)) / 100
    Mid(Value, i, 1) = Chr(0)
End If

i = 0
pnt(1) = 1
For t = 2 To 3
    i = InStr(i + 1, Value, ":")
    If i > 0 Then pnt(t) = i + 1 Else Exit For
Next t
numpnt = t - 1

For t = 1 To numpnt
    pnt(t) = Val(Mid(Value, pnt(t)))
Next t

'For t = numpnt To 1 Step -1
'    Select Case numpnt - t
'        Case 0: result = result +
'        Case 1: result = result + Val(Mid(value, pnt(t))) * 60
'    End Select
'Next t

If numpnt = 3 Then
    h = pnt(1)
    h = h * 3600
    result = result + h + pnt(2) * 60 + pnt(3)
ElseIf numpnt = 2 Then
    result = result + pnt(1) * 60 + pnt(2)
ElseIf numpnt = 1 Then
    result = result + pnt(1)
End If

ConvertInt = result
End Function

Function GetTimerCoord(i As Long, x As Integer, y As Integer)
           GetTimerCoord = 0
    With Tmr(i)
            x = Ptmr.x0 + Ptmr.xsize * (.col - Ptmr.ScrTimerLeft - 1)
            y = Ptmr.y0 + Ptmr.ysize * (.row - Ptmr.ScrTimerTop - 1)
            'if timer is out of window borders
            If x + Ptmr.xsize <= Ptmr.x0 Then Exit Function
            If y + Ptmr.ysize <= Ptmr.y0 Then Exit Function
            If x >= Ptmr.ScrXsize Then Exit Function
            If y >= Ptmr.ScrYsize Then Exit Function
    End With
            GetTimerCoord = 1
End Function

Sub RefreshOneTimer(i As Long, ctrl As Control, x As Integer, y As Integer)
If Sel.busy = True Then Exit Sub
Dim p As Single
Dim buf As String
Dim r As Integer
Dim g As Integer
Dim b As Integer

Dim TimeLeft As Single
Dim maintmr As Boolean
    With Tmr(i)
        If x = 0 And y = 0 Then
            If GetTimerCoord(i, x, y) = 0 Then Exit Sub
        End If
        
        If .active = 1 Or .active = 2 Then
                
                If .TimeLeft >= 0 And .TimeLeft < 30 Then
                    r = 255
                    b = 255 * (.TimeLeft / 30)
                    g = 100 + 155 * (.TimeLeft / 30)
                Else
                    r = 255
                    g = 255
                    b = 255
                End If
                
                If .active = 2 Then
                    r = r - 20
                    g = g - 20
                    If r < 0 Then r = 0
                    If g < 0 Then g = 0
                End If
                
                If TimerTime(.col) <> 0 Then
                    p = (.TimeLeft) / TimerTime(.col)
                    p = CLng(p * (Ptmr.xsize - 4))
                End If
                
                If p < 1 Then p = 1
                If p > Ptmr.xsize - 4 Then p = Ptmr.xsize - 4
                
                               
                ctrl.FillColor = RGB(r, g, b)
                
                ctrl.ForeColor = ctrl.FillColor
                ctrl.FillStyle = 0
                ctrl.DrawStyle = 5
                
                If i = Ptmr.urgenttimer Then Ptmr.urgentcolor = ctrl.FillColor
                
                Rectangle ctrl.hdc, x + 3, y + 2, x + Ptmr.xsize - p, y + Ptmr.ysize - 2
                
                If .active = 1 Then
                    ctrl.FillColor = Ptmr.BackColor
                Else
                    ctrl.FillColor = PlanTimer.PlanPic.BackColor
                End If
                
                ctrl.ForeColor = ctrl.FillColor
                ctrl.FillStyle = 0
                ctrl.DrawStyle = 5
                Rectangle ctrl.hdc, x + Ptmr.xsize - p - 1, y + 2, x + Ptmr.xsize - 1, y + Ptmr.ysize - 2
        End If
            

        If .active = 3 Then
                    ctrl.FillColor = RGB(255, 255, 0)
                    ctrl.ForeColor = ctrl.FillColor
                    ctrl.FillStyle = 0
                    ctrl.DrawStyle = 5
                    If i = Ptmr.urgenttimer Then Ptmr.urgentcolor = ctrl.FillColor
                    Rectangle ctrl.hdc, x + 3, y + 2, x + Ptmr.xsize - 1, y + Ptmr.ysize - 2
        End If
                    
        If .active = 12 Then
            ',      
                    If TimerCount2 = 1 Or TimerCount2 = 3 Or TimerCount2 = 5 Then
                        ctrl.FillColor = RGB(255, 255, 0)
                    Else
                        ctrl.FillColor = ctrl.BackColor
                    End If
                    ctrl.ForeColor = ctrl.FillColor
                    ctrl.FillStyle = 0
                    ctrl.DrawStyle = 5
                    Rectangle ctrl.hdc, x + 3, y + 2, x + Ptmr.xsize - 1, y + Ptmr.ysize - 2
                    TimerCount2 = TimerCount2 + 1
                    If TimerCount2 >= 7 Then
                        TimerCount2 = 0
                        .active = 4
                        RefreshInactiveTimers
                    End If
        End If
                    

        If .active = 1 Or .active = 2 Or .active = 3 Or .active = 12 Then '    4
                ctrl.ForeColor = 0
                'ctrl.FontSize = Ptmr.FontSize
                If Ptmr.TimerDir = 1 Then
                    buf = TimeFormat(CLng(.TimeLeft))
                    TextOut ctrl.hdc, x + Ptmr.xsize - TextLen(ctrl.hdc, buf) - 4, y + 4, buf, Len(buf)
                Else
                    buf = TimeFormat(CLng(.TimePassed))
                    TextOut ctrl.hdc, x + 4, y + 4, buf, Len(buf)
                End If
                    TimerTableLeft(i) = .TimeLeft
                    TimerTablePassed(i) = .TimePassed
        End If
       

        
        If .active = 6 Then
            If TimerCount = 3 Then ShowActualIcon ctrl, x, y
            If TimerCount = 6 Then HideActualIcon ctrl, x, y
        End If
        
        If .active = 10 Or .active = 11 Then
            'nextrowtimer
                ctrl.ForeColor = ctrl.BackColor
                ctrl.FillColor = ctrl.BackColor
                ctrl.FillStyle = 0
                ctrl.DrawStyle = 5
                Rectangle ctrl.hdc, x + 3, y + 2, x + Ptmr.xsize - 1, y + Ptmr.ysize - 2
                
                'ctrl.FontSize = Ptmr.FontSize
                If Ptmr.TimerDir = 1 Then
                    buf = TimeFormat(CLng(.TimeLeft))
                    ctrl.ForeColor = 0
                    TextOut ctrl.hdc, x + Ptmr.xsize - TextLen(ctrl.hdc, buf) - 3, y + 5, buf, Len(buf)
                    ctrl.ForeColor = clr(9)
                    TextOut ctrl.hdc, x + Ptmr.xsize - TextLen(ctrl.hdc, buf) - 4, y + 4, buf, Len(buf)
                Else
                    buf = TimeFormat(CLng(.TimePassed))
                    ctrl.ForeColor = 0
                    TextOut ctrl.hdc, x + 5, y + 5, buf, Len(buf)
                    ctrl.ForeColor = clr(9)
                    TextOut ctrl.hdc, x + 5, y + 5, buf, Len(buf)
                End If
        End If
                
                
    End With
    
'ctrl.ForeColor = ctrl.BackColor
'ctrl.Refresh
End Sub


Function GetTimeFinish(tm As Single) As String
Dim tmfinish As Double
Dim tmdays As Long
Dim buf As String
Dim outbuf As String
        tmfinish = tm
        If tmfinish > 86400 Then
            '    
            tmdays = Int(tmfinish / 86400)
            tmfinish = tmfinish - tmdays * 86400
            tmdays = tmdays + CLng(Date)
            buf = Format(tmdays, "General Date")
        Else
            tmdays = 0
        End If
        If tmdays > 0 Then outbuf = " " + Left(buf, 5) Else outbuf = ""
        buf = TimeFormat(tmfinish)
        If Len(buf) < 6 Then buf = "0:" + buf
        outbuf = RTrim(outbuf) + " " + GetRString("c_1125", "") + " " + buf
        GetTimeFinish = outbuf
End Function

Sub DeleteTimer(Index As Long)
Dim x As Integer
Dim y As Integer
         If GetTimerCoord(Index, x, y) > 0 Then
                EraseTimer PlanTimer.PlanPic, x, y
                PlanTimer.PlanPic.refresh
         End If
         With Tmr(Index)
            .active = 0
            .row = 0
            .col = 0
        End With
        
End Sub


Public Sub EraseTimer(c As Control, x As Integer, y As Integer)
c.FillColor = c.BackColor
c.FillStyle = 0
c.DrawStyle = 5
Rectangle c.hdc, x + 3, y + 2, x + Ptmr.xsize - 1, y + Ptmr.ysize - 2
End Sub

Public Sub Timers_RefreshExternal(c As Control, x As Integer, y As Integer)
'      
Dim x1 As Integer
Dim y1 As Integer
Dim t As Integer
Dim i As Integer
    
If Ptmr.urgenttimer > 0 Then
    RefreshNumber Ptmr.urgenttimer, c, x, y
    RefreshOneTimer Ptmr.urgenttimer, c, x + 30, y
End If

If Ptmr.nextrowurgenttimer > 0 Then
    RefreshNumber Ptmr.nextrowurgenttimer, c, x, y + Ptmr.ysize
    RefreshOneTimer Ptmr.nextrowurgenttimer, c, x + 30, y + Ptmr.ysize
End If
c.refresh

End Sub

Public Sub RefreshNumber(num As Long, ctrl As Control, x As Integer, y As Integer)
    Dim buf As String
    ctrl.FillColor = ctrl.BackColor
    ctrl.FillStyle = 0
    ctrl.DrawStyle = 5
    ctrl.FontSize = Ptmr.FontSize
    Rectangle ctrl.hdc, x + 3, y + 2, x + 30, y + Ptmr.ysize - 2
    ctrl.ForeColor = 0
    buf = LTrim(Str(num))
    TextOut ctrl.hdc, x + 4, y + 4, buf, Len(buf)
End Sub

Public Sub RefreshUrgent(c As Control, t As Long, clr As Long)
Dim x1 As Integer
Dim x2 As Integer

If Sel.busy = True Then Exit Sub
'    
Dim buf As String
If t = 0 Then
    c.BorderStyle = 0
    c.Cls
Else
                x1 = c.Width * 0.2
                x2 = c.Width * 0.4
                c.BorderStyle = 1
                c.ForeColor = c.BackColor
                c.FillStyle = 0
                c.DrawStyle = 5
                c.FillColor = Ptmr.BackColor
                Rectangle c.hdc, 0, 0, x1, c.ScaleHeight + 1
                c.FillColor = PlanTimer.BackColor
                Rectangle c.hdc, x2, 0, c.ScaleWidth + 1, c.ScaleHeight + 1
                c.FillColor = clr
                Rectangle c.hdc, x1 - 1, 0, x2 + 1, c.ScaleHeight + 1
                c.ForeColor = 0
                buf = NumberText(Tmr(t).row)
                TextOut c.hdc, 8, 3, buf, Len(buf)
                If Ptmr.TimerDir = 1 Then
                    buf = TimeFormat(CLng(Tmr(t).TimeLeft))
                Else
                    buf = TimeFormat(CLng(Tmr(t).TimePassed))
                End If
                TextOut c.hdc, x1 + 8, 3, buf, Len(buf)
                c.ForeColor = RGB(255, 255, 255)
                
                If Tmr(t).TimeLeft < 0 Then
                    buf = GetRString("c_1130", "") + Tmr(t).TimeFinish
                Else
                    buf = GetRString("c_1124", "") + Tmr(t).TimeFinish
                End If
                TextOut c.hdc, x2 + 8, 3, buf, Len(buf)
End If
    c.refresh
End Sub

Sub Timers_Estimate()
Dim i As Long
Dim t As Long
Dim col As Long
Dim row As Long
Dim urg As Long
Dim nurg As Long

Dim MinTime As Single
Dim NMinTime As Single

MinTime = 10000000000#
NMinTime = 10000000000#

Ptmr.urgenttimer = 0
Ptmr.nextrowurgenttimer = 0
urg = 0
nurg = 0

For i = 1 To NumTimers
                If Tmr(i).TimeLeft < 0 And (Tmr(i).active = 1 Or Tmr(i).active = 10) Then
                        ' 
                        If Ptmr.Sound = 1 Then
                            OpenSound Ptmr.SoundFileName
                            PlaySound
                        End If
                        If Tmr(i).active = 10 Then Tmr(i).active = 11
                End If
                
                If Tmr(i).TimeLeft < 0 And Tmr(i).active = 1 Then
                        If Ptmr.Dependent = 1 Then
                                col = Tmr(i).col + 1
                                If col > Ptmr.maxcols Then
                                    AddRowsCols 0, col - Ptmr.maxcols
                                    
                                    PlanTimer.m_cScroll.Max(efsHorizontal) = PlanTimer.m_cScroll.Max(efsHorizontal) + 1
                                    PlanTimer.m_cScroll.Value(efsHorizontal) = PlanTimer.m_cScroll.Max(efsHorizontal)
                                    Ptmr.ScrTimerLeft = PlanTimer.m_cScroll.Value(efsHorizontal)

                                End If
                                row = Tmr(i).row
                                '      
                                For t = 1 To NumTimers
                                    If Tmr(t).row = row And Tmr(t).col = col Then Exit For
                                Next t
                                        
                                
                                If t > NumTimers Then
                                    If TimerTime(col) > 0 Then
                                        AddNewTimer row, col
                                        If Ptmr.AutoNextTimer = 1 Then
                                            Tmr(t).active = 1
                                            Tmr(i).active = 12
                                        Else
                                            Tmr(t).active = 6
                                            Tmr(i).active = 3
                                        End If
                                    ElseIf TimerTime(col) <= 0 Then
                                           Tmr(i).active = 12
                                    End If
                                Else
                                    Tmr(i).active = 3
                                End If
                        
                        Else
                            Tmr(i).active = 3
                        End If
                End If
Next i

'active=10 means nextrowtimer

For i = 1 To NumTimers
      With Tmr(i)
            If .active = 1 Or .active = 3 Or .active = 10 Or .active = 11 Then
                .TimeLeft = .EndTime - Timer
                .TimePassed = Timer - .StartTime
                
                If .active = 10 Or .active = 11 Then
                    If .TimeLeft < NMinTime Then
                        NMinTime = .TimeLeft
                        nurg = i
                    End If
                Else
                    If .TimeLeft < MinTime Then
                        MinTime = .TimeLeft
                        urg = i
                    End If
                End If
            End If
      End With
Next i

'Urgent timers
Ptmr.urgenttimer = urg
Ptmr.nextrowurgenttimer = nurg
End Sub

Sub ExportTimersTable()
Dim t_index() As Boolean
Dim one_row() As Single
Dim row_max As Long
Dim maxcol As Long
Dim row As Integer

Dim i As Integer
Dim buf As String
Dim hbuf As String
Dim k As Long

If NumTimers > 0 Then

ReDim t_index(1 To NumTimers) As Boolean
row = 0
Do
    ',  
    row = row + 1
    If row > Ptmr.maxrows Then Exit Do
    row_max = 0
    ReDim one_row(1 To 100) As Single
    
    For k = 1 To NumTimers
        With Tmr(k)
            If .row = row And .active < 10 Then
                '  nextrowtimer
                If .col > UBound(one_row) Then ReDim Preserve one_row(1 To .col) As Single
                If row_max < .col Then row_max = .col
                If Ptmr.TimerDir = 1 Then
                    one_row(.col) = .TimeLeft
                Else
                    one_row(.col) = .TimePassed
                End If
                t_index(k) = True
            End If
        End With
    Next k
    
    buf = buf + "'" + NumberText(row) + "'" + vbTab
    If row_max = 0 Then buf = buf + vbCrLf
    For k = 1 To row_max
        If one_row(k) <> 0 Then
'            buf = buf + TimeFormat(CLng(one_row(k)))
            buf = buf + LTrim(Str(CLng(one_row(k))))
        End If
        If k < row_max Then buf = buf + vbTab Else buf = buf + vbCrLf
    Next k
        
    If row_max > maxcol Then maxcol = row_max

',       
For k = 1 To NumTimers
    If Tmr(k).active < 10 And t_index(k) = False Then Exit For
Next k
If k > NumTimers Then Exit Do
Loop


Else
    maxcol = 0

End If

With Ptmr
    hbuf = CStr(Date) + vbTab + CStr(Time) + vbCrLf
    hbuf = hbuf + GetRString("c_1120", " ") + vbTab + .Name + vbCrLf
    hbuf = hbuf + GetRString("c_1121", "  ") + vbTab + PlanTimer.Interval.text + vbCrLf
    'hbuf = hbuf + GetRString("c_1122", " ") + vbTab
End With

hbuf = hbuf + vbTab
For k = 1 To maxcol
    If TimerName(k) = "" Then hbuf = hbuf + Default_TimerName + Str(k) Else hbuf = hbuf + TimerName(k)
    hbuf = hbuf + vbTab
Next k
hbuf = hbuf + vbCrLf

hbuf = hbuf + vbTab
For k = 1 To maxcol
hbuf = hbuf + "'" + TimerTimeText(k) + "'" + vbTab
Next k
hbuf = hbuf + vbCrLf

buf = hbuf + buf


cClip.ClipboardOpen PlanTimer.hWnd
cClip.ClearClipboard
cClip.SetTextData CF_TEXT, buf
cClip.SetTextData CF_UNICODETEXT, Ansi2Unicode(buf)
cClip.ClipboardClose

End Sub

Sub CheckPlanTimer()
    Dim i As Long
    'Dim active As Boolean
    'For i = 1 To Ptmr.maxrows
    '    If Tmr(i).active = 2 Then Exit For
    'Next i
    'If i <= Ptmr.NumRows Then active = True
    For i = 1 To NumTimers
        If Tmr(i).active > 0 Then Exit For
    Next i
    If i <= NumTimers Or Ptmr.urgenttimer > 0 Or Ptmr.nextrowurgenttimer > 0 Then
        ' -   plantimer
        i = AskQuestion(GetRString("c_AreYouSure_PlanTimer", " ,     PlanTimer?"), 2)
        If i = 1 Then cmd = -1 Else cmd = 0
    End If
End Sub

Function CheckPlanTimerData() As Boolean
If NumTimers > 0 Then CheckPlanTimerData = True Else CheckPlanTimerData = False
End Function

Public Function Ansi2Unicode(text As String) As String
Dim buf As String
Dim i As Integer
Dim k As Integer
Dim c As Byte
Dim l As Integer
Dim cp As Byte
k = 1
l = Len(text)
buf = String(l * 2 + 1, 0)
For i = 1 To l
    c = Asc(Mid(text, i, 1))
    If c > 176 Then
        c = c - 176
        cp = 4
    Else
        cp = 0
    End If

    Mid(buf, k, 1) = Chr(c)
    Mid(buf, k + 1, 1) = Chr(cp)
    k = k + 2
Next i
Ansi2Unicode = buf
End Function

