Attribute VB_Name = "Skin"
' RealTimer project

' File:           Skin.bas
' Author:      Colupaika at OpenScience Ltd
' Modif date: 08 - 2008
' Version:  2.0
' Distributed under GNU GPL v 2

'This module includes functions to manipulate button images stored in a single skin file

Option Explicit

'Skin constants
Public Const ButtonSizeX = 32
Public Const ButtonSizeY = 32
Public Const SkinColorMap = 98
Public Const SkinColorSize = 16

Dim SkinLoaded As Boolean
Dim SkinHDC As Long
Dim Btn As PictureBox

Sub SetSkin(Skin As PictureBox, ButtonPic As PictureBox)
'if skin picture is already loaded
SkinHDC = Skin.hdc
SkinLoaded = True
Set Btn = ButtonPic
Btn.AutoRedraw = True
Btn.Height = ButtonSizeY - 1
Btn.Width = ButtonSizeX - 1
End Sub

Sub LoadSkin(SkinFile As String, Skin As PictureBox, ButtonPic As PictureBox)
If SkinFile <> "" And Dir(SkinFile) <> "" Then
    Skin.Picture = LoadPicture(SkinFile)
    SkinLoaded = True
End If
SkinHDC = Skin.hdc
Set Btn = ButtonPic
Btn.AutoRedraw = True
Btn.Height = ButtonSizeY - 1
Btn.Width = ButtonSizeX - 1
End Sub

Function SkinColor(num As Integer) As Long
Dim ret As Long
ret = GetPixel(SkinHDC, SkinColorSize * (num - 0.5), SkinColorMap)
If ret = -1 Then ret = RGB(255, 255, 255)
SkinColor = ret
End Function


' *********************************** SKIN
Sub LoadSkinButton(c As Control, x As Integer, y As Integer)
On Local Error GoTo errorloadskinbutton
If c.tag = Str(y) Then Exit Sub
Btn.Height = ButtonSizeY
Btn.Width = ButtonSizeX
Btn.Cls
'BitBlt ButtonPic.hdc, 0, 0, ButtonSizeX, ButtonSizeY, SkinHDC, ButtonSizeX * X, ButtonSizeY * Y, vbSrcCopy
BitBlt Btn.hdc, 0, 0, ButtonSizeX, ButtonSizeY, SkinHDC, ButtonSizeX * x, ButtonSizeY * y, vbSrcCopy
c.Width = ButtonSizeX
c.Height = ButtonSizeY
c.Picture = Btn.Image
c.tag = Str(y)
'StandardButtons = False
exitloadskinbutton:
Exit Sub
errorloadskinbutton:
Resume exitloadskinbutton
End Sub

Sub LoadSkinImage(c As Control, x1 As Integer, y1 As Integer, w As Integer, h As Integer)
On Local Error GoTo errorloadskinimage
If c.tag = Str(x1 + y1) Then Exit Sub
Btn.Height = h
Btn.Width = w
BitBlt Btn.hdc, 0, 0, w, h, SkinHDC, x1, y1, vbSrcCopy
c.Width = w
c.Height = h
c.Picture = Btn.Image
c.tag = Str(x1 + y1)
exitloadskinimage:
Exit Sub
errorloadskinimage:
Resume exitloadskinimage
End Sub

